#include "stdafx.h"
#include "common.h"
#include "scriptHeaders.h"
#include "constanttable.h"

CConstantTable::~CConstantTable()
{
	m_Table.clear();
}

unsigned int CConstantTable::AddConstant(CONSTANT* constant)
{
	m_Table.push_back(constant);
	return (int unsigned)m_Table.size() - 1;
}

unsigned int CConstantTable::Contains(CONSTANT* constant)
{
	for (unsigned int i = 0; i < (unsigned int)m_Table.size(); i++)
		if (*((CONSTANT*)(m_Table[i])) == *constant)
			return i;

	return -1;
}

unsigned int CConstantTable::GetConstantNumber(CONSTANT* constant)
{
	int index = Contains(constant);

	if (index < 0)
		index = AddConstant(constant);

	return index;
}

unsigned int CConstantTable::GetIntNumber(int val)
{
	CONSTANT* pConstant = new CONSTANT;
	pConstant->type = INT_CONST;
	pConstant->val.intval = val;
	return GetConstantNumber(pConstant);
}

unsigned int CConstantTable::GetDoubleNumber(double val)
{
	CONSTANT* pConstant = new CONSTANT;
	pConstant->type = DOUBLE_CONST;
	pConstant->val.doubleval = val;
	return GetConstantNumber(pConstant);
}

unsigned int CConstantTable::GetStringNumber(char* val)
{
	CONSTANT* pConstant = new CONSTANT;
	pConstant->type = ZSTRING_CONST;
	pConstant->val.str = val;
	return GetConstantNumber(pConstant);
}

unsigned int CConstantTable::Size()
{
	return (unsigned int)m_Table.size();
}

CONSTANT*	CConstantTable::operator [] (unsigned int index)
{
	if (index > (unsigned int)m_Table.size())
		return NULL;
	else
		return m_Table[index];
}
